package com.humandevice.validator.rules;

import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.utils.ValidatorUtils;
import com.humandevice.validator.widget.ValidatorView;


/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class RegexRule extends Rule<RegexRule> {

    private String pattern;
    private boolean allowEmpty;

    public RegexRule(@NonNull String pattern) {
        this.pattern = pattern;
    }

    public RegexRule(@NonNull String pattern, boolean allowEmpty) {
        this.pattern = pattern;
        this.allowEmpty = allowEmpty;
    }

    @Override
    protected void checkView(ValidatorView view) throws ValidationException {
        String text = (String) ValidatorUtils.getValue(view);
        if (TextUtils.isEmpty(text) && allowEmpty) {
            return;
        }
        if (text == null || !text.matches(pattern)) {
            throw new ValidationException(view, message);
        }
    }

    @Override
    protected void checkInstance(ValidatorView view) throws IllegalArgumentException {
        if (!ValidatorUtils.isTextView(view)) {
            throw new IllegalArgumentException("View must extends TextView");
        }
    }
}