package com.humandevice.validator.errors;

import android.support.annotation.NonNull;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class ValidationError {

    private int mCode;

    @NonNull
    private String mFieldName;

    @NonNull
    private String mMessage;

    public ValidationError(@NonNull String fieldName, @NonNull String message) {
        mCode = -1;
        mFieldName = fieldName;
        mMessage = message;
    }

    public ValidationError(int code, @NonNull String fieldName, @NonNull String message) {
        mCode = code;
        mFieldName = fieldName;
        mMessage = message;
    }

    public int getCode() {
        return mCode;
    }

    @NonNull
    public String getFieldName() {
        return mFieldName;
    }

    @NonNull
    public String getMessage() {
        return mMessage;
    }

}
