package com.humandevice.validator.utils;

import android.support.annotation.NonNull;
import android.support.design.widget.TextInputLayout;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.ViewParent;
import android.widget.TextView;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class ErrorTextWatcher implements TextWatcher {

    @NonNull
    protected TextView v;

    public ErrorTextWatcher(@NonNull TextView v) {
        this.v = v;
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    @Override
    public void afterTextChanged(Editable s) {
        v.setError(null);
        ViewParent parent = v.getParent();
        if (parent instanceof TextInputLayout){
            ((TextInputLayout) parent).setError(null);
            ((TextInputLayout) parent).setErrorEnabled(false);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ErrorTextWatcher){
            return v.equals(((ErrorTextWatcher) o).v);
        }else{
            return super.equals(o);
        }
    }

    @Override
    public int hashCode() {
        return v.hashCode();
    }
}