package com.humandevice.validator.widget;

import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.util.Log;
import android.widget.TextView;

import com.humandevice.validator.errors.Errors;
import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.rules.Rule;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

/**
 * TODO Dokumentacja
 *
 * @author Rafal Zajfert
 * @date 2016-07-20
 */
class ValidatorViewDelegator implements ValidatorView {

	private Set<Rule> mRules = new TreeSet<>(new Rule.PriorityComparator());
	protected final Errors mErrors = new Errors();
	private String mName;

	@Override
	public void setName(String name) {
		mName = name;
	}

	@Override
	public String getName() {
		return mName;
	}

	@Override
	public void addRule(@NonNull Rule rule, Rule... otherRules) {
		mRules.add(rule);
		Collections.addAll(mRules, otherRules);
	}

	@Override
	public void addRules(@Size(min = 1) Rule[] rules) {
		Collections.addAll(mRules, rules);
	}

	@Override
	public Set<Rule> getRules() {
		return mRules;
	}

	@Override
	public boolean validate(int maxPriority) {
		throw new RuntimeException("Stub!");
	}

	public boolean validate(ValidatorView view, int maxPriority) {
		view.getErrors().clear();
		int errorRulePriority = Integer.MIN_VALUE;
		boolean valid = true;
		for (Rule rule : view.getRules()) {
			if (rule.getPriority() > maxPriority) {
				break;
			}
			if (errorRulePriority != Integer.MIN_VALUE && errorRulePriority != rule.getPriority()) {
				break;
			}

			try {
				rule.validate(view);
				Log.e("VVD", view.getName() + " " + rule.getClass().getSimpleName() + " " + true);
			} catch (ValidationException e) {
				Log.e("VVD", view.getName() + " " + rule.getClass().getSimpleName() + " " + false);
				valid = false;
				view.getErrors().add(e.getValidationError());
				errorRulePriority = rule.getPriority();
			}
		}
		Log.e("VVD", view.getName() + " " + valid);
		return valid;
	}

	@Override
	public Errors getErrors() {
		return mErrors;
	}

	@Override
	public boolean hasErrors() {
		return mErrors.hasErrors();
	}

	@Override
	public void clearErrors() {
		mErrors.clear();
	}

	@Override
	public void showErrors() {
		throw new RuntimeException("Stub!");
	}

	public void showErrors(TextView textView) {
		if (mErrors.hasErrors()) {
			textView.setError(mErrors.getCombinedMessage());
		} else {
			textView.setError(null);
		}
	}
}
