package com.humandevice.validator.rules;

import com.humandevice.validator.errors.ValidationException;
import com.humandevice.validator.widget.ValidatorView;

import java.util.Collection;

/**
 * Created by Rafal Zajfert on 10.08.2015.
 */
public class NotEmptyListRule<E> extends Rule<NotEmptyListRule<E>> {

    private Collection<E> collection;

    public NotEmptyListRule(Collection<E> collection) {
        this.collection = collection;
    }

    @Override
    protected void checkView(ValidatorView view) throws ValidationException {
        if (collection == null || collection.isEmpty()) {
            throw new ValidationException(view, message);
        }
    }

    @Override
    protected void checkInstance(ValidatorView view) throws IllegalArgumentException {
    }
}
