/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.dao.impl;

import com.humandevice.libraries.dao.Dao;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Session;

public class HibernateAbstractDao<TEntityImpl, TPrimaryKey>
implements Dao<TEntityImpl, TPrimaryKey> {
    @PersistenceContext
    protected EntityManager entityManager;
    private Class<? extends TEntityImpl> entityClass;

    public HibernateAbstractDao(Class<? extends TEntityImpl> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public void save(TEntityImpl entity) {
        this.entityManager.persist(entity);
    }

    @Override
    public void update(TEntityImpl entity) {
        this.entityManager.merge(entity);
    }

    @Override
    public void detach(TEntityImpl entity) {
        this.entityManager.detach(entity);
    }

    @Override
    public void delete(TEntityImpl entity) {
        this.entityManager.remove(entity);
    }

    @Override
    public boolean loaded(TEntityImpl entity) {
        return this.entityManager.contains(entity);
    }

    @Override
    public void flush() {
        this.entityManager.flush();
    }

    @Override
    public TEntityImpl findByPk(TPrimaryKey pk) {
        return (TEntityImpl)this.entityManager.find(this.entityClass, pk);
    }

    @Override
    public List<TEntityImpl> getList() {
        return this.entityManager.createQuery("from " + this.entityClass.getName(), this.entityClass).getResultList();
    }

    public Session getHibernateSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Criteria createEntityCriteria() {
        return this.getHibernateSession().createCriteria(this.entityClass);
    }
}

