/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.operationresult;

import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.ResultStatus;
import com.humandevice.libraries.operationresult.impl.ErrorOperationResult;
import com.humandevice.libraries.operationresult.impl.SuccessOperationResult;
import com.humandevice.libraries.operationresult.impl.WarningOperationResult;

public class OperationResultFactory {
    public static OperationResult createOperationResult(ResultStatus status) {
        switch (status) {
            case SUCCESS: {
                return new SuccessOperationResult();
            }
            case WARNING: {
                return new WarningOperationResult();
            }
            case ERROR: {
                return new ErrorOperationResult();
            }
        }
        return null;
    }

    protected static OperationResult createOperationResult(ResultStatus status, Integer messageCode, String message) {
        OperationResult operationResult = OperationResultFactory.createOperationResult(status);
        operationResult.addMessage(messageCode, message);
        return operationResult;
    }

    public static OperationResult createSuccessOperationResult() {
        return OperationResultFactory.createOperationResult(ResultStatus.SUCCESS);
    }

    public static OperationResult createSuccessOperationResult(String message) {
        return OperationResultFactory.createOperationResult(ResultStatus.SUCCESS, -1, message);
    }

    public static OperationResult createErrorOperationResult() {
        return OperationResultFactory.createOperationResult(ResultStatus.ERROR);
    }

    public static OperationResult createErrorOperationResult(String message) {
        return OperationResultFactory.createOperationResult(ResultStatus.ERROR, -1, message);
    }

    public static OperationResult createWarningOperationResult() {
        return OperationResultFactory.createOperationResult(ResultStatus.WARNING);
    }

    public static OperationResult createWarningOperationResult(String message) {
        return OperationResultFactory.createOperationResult(ResultStatus.WARNING, -1, message);
    }
}

