/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.operationresult.impl;

import com.humandevice.libraries.operationresult.Message;
import com.humandevice.libraries.operationresult.NullMessage;
import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.ResultStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractOperationResult
implements OperationResult {
    protected ResultStatus status;
    protected Integer code;
    protected List<Message> messages = new ArrayList<Message>();
    protected Map<String, Object> values = new HashMap<String, Object>();

    @Override
    public ResultStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(ResultStatus status) {
        this.status = status;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public void addMessage(Integer messageCode, String messageContent) {
        Message message = new Message();
        message.setCode(messageCode);
        message.setContent(messageContent);
        this.messages.add(message);
    }

    @Override
    public List<Message> getMessages() {
        return this.messages;
    }

    @Override
    public Message getFirstMessage() {
        if (this.messages.size() > 0) {
            return this.messages.get(0);
        }
        return new NullMessage();
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    @Override
    public Object getValue(String name) {
        return this.getValues().get(name);
    }

    @Override
    public void setValue(String name, Object value) {
        this.getValues().put(name, value);
    }

    public AbstractOperationResult merge(AbstractOperationResult operationResult) {
        this.messages.addAll(operationResult.getMessages());
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.status == ResultStatus.SUCCESS;
    }

    @Override
    public boolean isWarning() {
        return this.status == ResultStatus.WARNING;
    }

    @Override
    public boolean isError() {
        return this.status == ResultStatus.ERROR;
    }
}

