/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.services.configuration.domain;

import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.ResultStatus;
import com.humandevice.libraries.operationresult.impl.SuccessOperationResult;
import com.humandevice.libraries.services.configuration.domain.ConfigService;
import com.humandevice.libraries.services.configuration.exceptions.ParameterDoesNotExists;
import com.humandevice.libraries.services.configuration.readerwriter.ConfigReaderWriter;
import java.util.Map;

public class DefaultConfigService
implements ConfigService {
    protected ConfigReaderWriter configReaderWriter;
    private Map<String, String> parameters;

    @Override
    public OperationResult loadConfiguration() {
        OperationResult operationResult = this.configReaderWriter.readConfiguration();
        if (operationResult.getStatus() == ResultStatus.ERROR) {
            return operationResult;
        }
        this.parameters = (Map)operationResult.getValue("READ_CONFIGURATION__PARAMETERS");
        return new SuccessOperationResult();
    }

    @Override
    public OperationResult saveConfiguration() {
        return this.configReaderWriter.writeConfiguration(this.parameters);
    }

    @Override
    public Boolean parameterExists(String name) {
        return this.parameters.containsKey(name);
    }

    @Override
    public String getStringParameter(String name) throws ParameterDoesNotExists {
        if (!this.parameterExists(name).booleanValue()) {
            throw new ParameterDoesNotExists(name);
        }
        return this.parameters.get(name);
    }

    @Override
    public Integer getIntegerParameter(String name) {
        Integer value = null;
        try {
            String valueString = this.getStringParameter(name);
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public Double getDoubleParameter(String name) {
        Double value = null;
        try {
            String valueString = this.getStringParameter(name);
            value = Double.parseDouble(valueString);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public Boolean getBooleanParameter(String name) {
        Boolean value = null;
        try {
            String valueString = this.getStringParameter(name);
            value = valueString.equals("1");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public ConfigService setStringParameter(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public ConfigService setIntegerParameter(String name, Integer value) {
        this.parameters.put(name, value.toString());
        return this;
    }

    @Override
    public ConfigService setDoubleParameter(String name, Double value) {
        this.parameters.put(name, value.toString());
        return this;
    }

    @Override
    public ConfigService setBooleanParameter(String name, Boolean value) {
        this.parameters.put(name, value != false ? "1" : "0");
        return this;
    }

    @Override
    public void setConfigReaderWriter(ConfigReaderWriter configReaderWriter) {
        this.configReaderWriter = configReaderWriter;
    }
}

