/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.services.configuration.readerwriter;

import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.impl.SuccessOperationResult;
import com.humandevice.libraries.services.configuration.dao.ConfigDao;
import com.humandevice.libraries.services.configuration.entity.ConfigEntity;
import com.humandevice.libraries.services.configuration.entity.HibernateConfigEntity;
import com.humandevice.libraries.services.configuration.readerwriter.AbstractConfigReaderWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DatabaseConfigReaderWriter
extends AbstractConfigReaderWriter {
    protected ConfigDao configDao;

    @Override
    public OperationResult readConfiguration() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        List configurations = this.configDao.getList();
        for (ConfigEntity configuration : configurations) {
            parameters.put(configuration.getName(), configuration.getValue());
        }
        SuccessOperationResult operationResult = new SuccessOperationResult();
        operationResult.setValue("READ_CONFIGURATION__PARAMETERS", parameters);
        return operationResult;
    }

    @Override
    public OperationResult writeConfiguration(Map<String, String> parameters) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            ConfigEntity configuration = this.configDao.getConfigByName(parameter.getKey());
            if (configuration == null) {
                configuration = new HibernateConfigEntity();
                configuration.setName(parameter.getKey());
                configuration.setValue(parameter.getValue());
                this.configDao.save(configuration);
                continue;
            }
            this.configDao.update(configuration);
        }
        return new SuccessOperationResult();
    }

    public void setConfigDao(ConfigDao configDao) {
        this.configDao = configDao;
    }
}

