/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.services.email.sender;

import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.impl.ErrorOperationResult;
import com.humandevice.libraries.operationresult.impl.SuccessOperationResult;
import com.humandevice.libraries.services.email.message.EmailMessage;
import com.humandevice.libraries.services.email.sender.AbstractEmailSender;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class JavaSmtpEmailSender
extends AbstractEmailSender {
    public static String MAIL_SMTP_HOST = "mail.smtp.host";
    public static String MAIL_SMTP_PORT = "mail.smtp.port";
    public static String MAIL_SMTP_NAME = "mail.smtp.name";
    public static String MAIL_SMTP_USER = "mail.smtp.user";
    public static String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    public static String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static String MAIL_SMTP_DEBUG = "mail.smtp.debug";

    @Override
    public OperationResult sendEmailMessage(EmailMessage emailMessage) {
        String host = this.configService.getStringParameter(MAIL_SMTP_HOST);
        String port = this.configService.getStringParameter(MAIL_SMTP_PORT);
        final String user = this.configService.getStringParameter(MAIL_SMTP_USER);
        final String password = this.configService.getStringParameter(MAIL_SMTP_PASSWORD);
        String tls = this.configService.getStringParameter(MAIL_SMTP_STARTTLS_ENABLE);
        String auth = this.configService.getStringParameter(MAIL_SMTP_AUTH);
        String name = this.configService.getStringParameter(MAIL_SMTP_NAME);
        Boolean debug = this.configService.getBooleanParameter(MAIL_SMTP_DEBUG);
        Properties properties = System.getProperties();
        properties.put(MAIL_SMTP_HOST, host);
        properties.put(MAIL_SMTP_PORT, port);
        properties.put(MAIL_SMTP_STARTTLS_ENABLE, tls);
        properties.put(MAIL_SMTP_AUTH, auth);
        Session session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password);
            }
        });
        if (debug.booleanValue()) {
            session.setDebug(true);
        }
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setHeader("Content-Encoding", "utf-8");
            mimeMessage.setFrom((Address)new InternetAddress(user, name));
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(emailMessage.getTo(), emailMessage.getToName()));
            mimeMessage.setSubject(emailMessage.getSubject(), "utf-8");
            MimeMultipart messageParts = new MimeMultipart("related");
            MimeMultipart alternativeMultipart = new MimeMultipart("alternative");
            MimeBodyPart plainMessage = new MimeBodyPart();
            plainMessage.setContent((Object)emailMessage.getContentPlain(), "text/plain; charset=utf-8");
            alternativeMultipart.addBodyPart((BodyPart)plainMessage);
            MimeBodyPart htmlMessage = new MimeBodyPart();
            htmlMessage.setContent((Object)emailMessage.getContentHtml(), "text/html; charset=utf-8");
            alternativeMultipart.addBodyPart((BodyPart)htmlMessage);
            MimeBodyPart contentPart = new MimeBodyPart();
            contentPart.setContent((Multipart)alternativeMultipart);
            messageParts.addBodyPart((BodyPart)contentPart);
            mimeMessage.setContent((Multipart)messageParts);
            Transport.send((Message)mimeMessage);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            ErrorOperationResult operationResult = new ErrorOperationResult();
            operationResult.addMessage(Integer.valueOf(-1), e.getLocalizedMessage());
            return operationResult;
        }
        SuccessOperationResult operationResult = new SuccessOperationResult();
        return operationResult;
    }
}

