/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.services.email.processor;

import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.impl.ErrorOperationResult;
import com.humandevice.libraries.operationresult.impl.SuccessOperationResult;
import com.humandevice.libraries.services.email.message.EmailMessage;
import com.humandevice.libraries.services.email.processor.AbstractEmailProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class SimpleTemplateEmailProcessor
extends AbstractEmailProcessor {
    private String templatePath;
    private String contentTag = "[[content]]";

    @Override
    public OperationResult process(EmailMessage emailMessage) {
        File templateFile = new File(this.templatePath);
        try {
            String template = new String(Files.readAllBytes(Paths.get(templateFile.getAbsolutePath(), new String[0])));
            emailMessage.setContentHtml(template.replace(this.contentTag, emailMessage.getContentHtml()));
        }
        catch (IOException e) {
            ErrorOperationResult operationResult = new ErrorOperationResult();
            operationResult.addMessage(Integer.valueOf(-1), e.getLocalizedMessage());
            return operationResult;
        }
        SuccessOperationResult operationResult = new SuccessOperationResult();
        operationResult.setValue("PROCESS__MAIL_MESSAGE", (Object)emailMessage);
        return operationResult;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void setContentTag(String contentTag) {
        this.contentTag = contentTag;
    }
}

