/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.services.sms.sender;

import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.impl.ErrorOperationResult;
import com.humandevice.libraries.operationresult.impl.SuccessOperationResult;
import com.humandevice.libraries.services.sms.message.SmsMessage;
import com.humandevice.libraries.services.sms.sender.AbstractSmsSender;
import org.apache.log4j.Logger;
import pl.smsapi.Client;
import pl.smsapi.api.SmsFactory;
import pl.smsapi.api.action.sms.SMSSend;
import pl.smsapi.api.response.StatusResponse;
import pl.smsapi.exception.SmsapiException;

public class SmsApiSmsSender
extends AbstractSmsSender {
    Logger LOGGER = Logger.getLogger(SmsApiSmsSender.class);
    public static String SMS_API_USER = "sms_api_user";
    public static String SMS_API_PASSWORD = "sms_api_password";
    public static String SMS_API_SENDER_NAME = "sms_api_sender_name";
    public static String SMS_API_SANDBOX = "sms_api_sandbox";

    @Override
    public OperationResult sendSmsMessage(SmsMessage smsMessage) {
        String user = this.configService.getStringParameter(SMS_API_USER);
        String password = this.configService.getStringParameter(SMS_API_PASSWORD);
        String senderName = this.configService.getStringParameter(SMS_API_SENDER_NAME);
        Boolean sandbox = this.configService.getBooleanParameter(SMS_API_SANDBOX);
        try {
            Client client = new Client(user);
            client.setPasswordHash(password);
            SmsFactory smsApi = new SmsFactory(client);
            SMSSend action = (SMSSend)((SMSSend)smsApi.actionSend().setTest(sandbox.booleanValue())).setText(smsMessage.getContent()).setTo(smsMessage.getPhoneNumber());
            StatusResponse result = (StatusResponse)action.execute();
        }
        catch (SmsapiException e) {
            e.printStackTrace();
            ErrorOperationResult operationResult = new ErrorOperationResult();
            operationResult.addMessage(Integer.valueOf(-1), e.getMessage());
            return operationResult;
        }
        this.LOGGER.info((Object)String.format("SMSAPI.PL: sms to %s sent", smsMessage.getPhoneNumber()));
        return new SuccessOperationResult();
    }
}

