/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.worker;

import com.humandevice.libraries.worker.AbstractWorker;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.SimpleTriggerContext;

public abstract class CronWorker
extends AbstractWorker {
    Logger LOGGER = Logger.getLogger(CronWorker.class);
    protected String cronExpression = "* */10 * * * *";
    protected boolean executeAtStart = false;
    protected CronTrigger cronTrigger;
    protected SimpleTriggerContext cronTriggerContext;
    protected DateTime nextExecutionTime = null;

    @Override
    public void init() {
        super.init();
        this.cronTrigger = new CronTrigger(this.cronExpression);
        this.cronTriggerContext = new SimpleTriggerContext();
        DateTime now = DateTime.now();
        if (this.executeAtStart) {
            this.nextExecutionTime = now.minus(1L);
        } else {
            this.nextExecutionTime = new DateTime((Object)this.cronTrigger.nextExecutionTime((TriggerContext)this.cronTriggerContext));
            this.LOGGER.info((Object)this.nextExecutionTime.toString());
        }
    }

    @Override
    public boolean checkConditions() {
        this.cronTrigger = new CronTrigger(this.cronExpression);
        if (this.nextExecutionTime.isBeforeNow()) {
            this.nextExecutionTime = new DateTime((Object)this.cronTrigger.nextExecutionTime((TriggerContext)this.cronTriggerContext));
            this.LOGGER.info((Object)String.format("conditions fulfilled, next execution at %s", this.nextExecutionTime.toString()));
            return true;
        }
        this.LOGGER.info((Object)String.format("conditions not fulfilled, execution at %s", this.nextExecutionTime.toString()));
        return false;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setExecuteAtStart(boolean executeAtStart) {
        this.executeAtStart = executeAtStart;
    }
}

