/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.worker;

import com.humandevice.libraries.worker.AbstractWorker;
import java.time.LocalDateTime;
import org.apache.log4j.Logger;

public abstract class MinutesIntervalWorker
extends AbstractWorker {
    Logger LOGGER = Logger.getLogger(MinutesIntervalWorker.class);
    protected Integer minutesInterval = 10;
    protected LocalDateTime lastExecution;
    protected boolean executeAtStart = false;

    @Override
    public void init() {
        super.init();
        if (!this.executeAtStart) {
            this.lastExecution = LocalDateTime.now();
        }
    }

    @Override
    public boolean checkConditions() {
        if (this.lastExecution == null) {
            this.lastExecution = LocalDateTime.now();
            this.LOGGER.info((Object)"execution at start");
            return true;
        }
        LocalDateTime nextExecution = this.lastExecution.plusMinutes(this.minutesInterval.intValue());
        if (nextExecution.isBefore(LocalDateTime.now())) {
            this.lastExecution = LocalDateTime.now();
            this.LOGGER.info((Object)"conditions fulfilled");
            return true;
        }
        this.LOGGER.info((Object)String.format("conditions not fulfilled, execution at %s", nextExecution.toString()));
        return false;
    }

    public void setMinutesInterval(Integer minutesInterval) {
        this.minutesInterval = minutesInterval;
    }

    public void setExecuteAtStart(boolean executeAtStart) {
        this.executeAtStart = executeAtStart;
    }
}

