/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.workers.emailsender;

import com.humandevice.libraries.operationresult.Message;
import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.ResultStatus;
import com.humandevice.libraries.services.email.domain.EmailService;
import com.humandevice.libraries.services.email.entity.EmailEntity;
import com.humandevice.libraries.services.email.manager.EmailManager;
import com.humandevice.libraries.worker.AbstractWorker;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class EmailSenderWorker
extends AbstractWorker {
    Logger LOGGER = Logger.getLogger(EmailSenderWorker.class);
    private ArrayList<EmailEntity> queue = new ArrayList();
    private EmailManager emailManager;
    private EmailService emailService;

    public void process() {
        for (EmailEntity email : this.queue) {
            OperationResult operationResult = this.emailManager.sendEmailMessage(email.getName(), email.getAddress(), email.getSubject(), email.getContentPlain(), email.getContentHtml());
            if (operationResult.getStatus() == ResultStatus.ERROR) {
                for (Message message : operationResult.getMessages()) {
                    this.LOGGER.error((Object)message.getContent());
                }
                return;
            }
            this.emailService.updateEmailStatus(email.getId(), "sent");
            if (operationResult.getStatus() == ResultStatus.ERROR) {
                for (Message message : operationResult.getMessages()) {
                    this.LOGGER.error((Object)message.getContent());
                }
                return;
            }
            this.LOGGER.info((Object)String.format("Email id=%d sent", email.getId()));
        }
        this.queue.clear();
    }

    public boolean checkConditions() {
        if (this.queue.isEmpty()) {
            OperationResult operationResult = this.emailService.getPendingEmails();
            if (operationResult.getStatus() == ResultStatus.ERROR) {
                for (Message message : operationResult.getMessages()) {
                    this.LOGGER.error((Object)message.getContent());
                }
                return false;
            }
            List emails = (List)operationResult.getValue("GET_PENDING_MASS_EMAILS_MASS_EMAILS_PARAMETER");
            this.queue.addAll(emails);
        }
        this.LOGGER.info((Object)("Queue email length: " + this.queue.size()));
        return !this.queue.isEmpty();
    }

    public String toString() {
        return EmailSenderWorker.class.getSimpleName();
    }

    public void setEmailManager(EmailManager emailManager) {
        this.emailManager = emailManager;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
}

