/*
 * Decompiled with CFR 0.152.
 */
package com.humandevice.libraries.workers.smssender;

import com.humandevice.libraries.operationresult.Message;
import com.humandevice.libraries.operationresult.OperationResult;
import com.humandevice.libraries.operationresult.ResultStatus;
import com.humandevice.libraries.services.sms.domain.SmsService;
import com.humandevice.libraries.services.sms.entity.SmsMessageEntity;
import com.humandevice.libraries.services.sms.entity.SmsMessageStatus;
import com.humandevice.libraries.services.sms.manager.SmsManager;
import com.humandevice.libraries.worker.AbstractWorker;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class SmsSenderWorker
extends AbstractWorker {
    Logger LOGGER = Logger.getLogger(SmsSenderWorker.class);
    private ArrayList<SmsMessageEntity> pendingSmsMessages = new ArrayList();
    private SmsManager smsManager;
    private SmsService smsService;

    public void process() {
        for (SmsMessageEntity smsMessage : this.pendingSmsMessages) {
            OperationResult updateStatusOperationResult;
            OperationResult sendSmsOperationResult = this.smsManager.sendSmsMessage(smsMessage.getPhoneNumber(), smsMessage.getContent());
            if (!sendSmsOperationResult.isSuccess()) {
                for (Message message : sendSmsOperationResult.getMessages()) {
                    this.LOGGER.error((Object)message.toString());
                }
                updateStatusOperationResult = this.smsService.updateSmsMessageStatus((Integer)smsMessage.getId(), SmsMessageStatus.error);
                if (!updateStatusOperationResult.isSuccess()) {
                    for (Message message : updateStatusOperationResult.getMessages()) {
                        this.LOGGER.error((Object)message.toString());
                    }
                }
                if (!sendSmsOperationResult.isError()) continue;
                this.close();
                this.LOGGER.error((Object)"Wy\u0139\u201a\u00c4\u2026czenie workera SmsSenderWorker z powodu powa\u0139\u013dnego b\u0139\u201a\u00c4\u2122du");
                return;
            }
            updateStatusOperationResult = this.smsService.updateSmsMessageStatus((Integer)smsMessage.getId(), SmsMessageStatus.sent);
            if (!updateStatusOperationResult.isSuccess()) {
                for (Message message : updateStatusOperationResult.getMessages()) {
                    this.LOGGER.error((Object)message.toString());
                }
                continue;
            }
            this.LOGGER.info((Object)String.format("Sms id=%d sent", smsMessage.getId()));
        }
        this.pendingSmsMessages.clear();
    }

    public boolean checkConditions() {
        if (this.pendingSmsMessages.isEmpty()) {
            OperationResult operationResult = this.smsService.getPendingSmsMessages();
            if (operationResult.getStatus() == ResultStatus.ERROR) {
                for (Message message : operationResult.getMessages()) {
                    this.LOGGER.error((Object)message.toString());
                }
                return false;
            }
            List smsMessages = (List)operationResult.getValue("GET_PENDING_SMS__SMS");
            this.pendingSmsMessages.addAll(smsMessages);
        }
        this.LOGGER.info((Object)("Queue sms length: " + this.pendingSmsMessages.size()));
        return !this.pendingSmsMessages.isEmpty();
    }

    public String toString() {
        return SmsSenderWorker.class.getSimpleName();
    }

    public void setSmsManager(SmsManager smsManager) {
        this.smsManager = smsManager;
    }

    public void setSmsService(SmsService smsService) {
        this.smsService = smsService;
    }
}

