/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TimeoutTimer;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class TDSCommand {
    static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Command");
    private final String logContext;
    private String traceID;
    private final TimeoutTimer timeoutTimer;
    private volatile TDSWriter tdsWriter;
    private volatile TDSReader tdsReader;
    private final Object interruptLock = new Object();
    private volatile boolean interruptsEnabled = false;
    private volatile boolean wasInterrupted = false;
    private volatile String interruptReason = null;
    private volatile boolean requestComplete;
    private volatile boolean attentionPending = false;
    private volatile boolean processedResponse;
    private volatile boolean readingResponse;
    private boolean interruptChecked = false;

    abstract boolean doExecute() throws SQLServerException;

    final String getLogContext() {
        return this.logContext;
    }

    public final String toString() {
        if (this.traceID == null) {
            this.traceID = "TDSCommand@" + Integer.toHexString(this.hashCode()) + " (" + this.logContext + ")";
        }
        return this.traceID;
    }

    final void log(Level level, String string) {
        logger.log(level, this.toString() + ": " + string);
    }

    private final boolean wasInterrupted() {
        return this.wasInterrupted;
    }

    boolean attentionPending() {
        return this.attentionPending;
    }

    final boolean readingResponse() {
        return this.readingResponse;
    }

    TDSCommand(String string, int n) {
        this.logContext = string;
        this.timeoutTimer = n > 0 ? new TimeoutTimer(n, this) : null;
    }

    boolean execute(TDSWriter tDSWriter, TDSReader tDSReader) throws SQLServerException {
        this.tdsWriter = tDSWriter;
        this.tdsReader = tDSReader;
        assert (null != tDSReader);
        try {
            return this.doExecute();
        }
        catch (SQLServerException sQLServerException) {
            block6: {
                try {
                    if (!this.requestComplete && !tDSReader.getConnection().isClosed()) {
                        this.interrupt(sQLServerException.getMessage());
                        this.onRequestComplete();
                        this.close();
                    }
                }
                catch (SQLServerException sQLServerException2) {
                    if (!logger.isLoggable(Level.FINE)) break block6;
                    logger.fine(this.toString() + ": Ignoring error in sending attention: " + sQLServerException2.getMessage());
                }
            }
            throw sQLServerException;
        }
    }

    void processResponse(TDSReader tDSReader) throws SQLServerException {
        block4: {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Processing response");
            }
            try {
                TDSParser.parse(tDSReader, this.getLogContext());
            }
            catch (SQLServerException sQLServerException) {
                if (2 != sQLServerException.getDriverErrorCode()) {
                    throw sQLServerException;
                }
                if (!logger.isLoggable(Level.FINEST)) break block4;
                logger.finest(this.toString() + ": Ignoring error from database: " + sQLServerException.getMessage());
            }
        }
    }

    final void detach() throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": detaching...");
        }
        while (this.tdsReader.readPacket()) {
        }
        assert (!this.readingResponse);
    }

    final void close() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": closing...");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": processing response...");
        }
        while (!this.processedResponse) {
            try {
                this.processResponse(this.tdsReader);
            }
            catch (SQLServerException sQLServerException) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this + ": close ignoring error processing response: " + sQLServerException.getMessage());
                }
                if (!this.tdsReader.getConnection().isSessionUnAvailable()) continue;
                this.processedResponse = true;
                this.attentionPending = false;
            }
        }
        if (this.attentionPending) {
            block18: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this + ": processing attention ack...");
                }
                try {
                    TDSParser.parse(this.tdsReader, "attention ack");
                }
                catch (SQLServerException sQLServerException) {
                    if (this.tdsReader.getConnection().isSessionUnAvailable()) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this + ": giving up on attention ack after connection closed by exception: " + sQLServerException);
                        }
                        this.attentionPending = false;
                    }
                    if (!logger.isLoggable(Level.FINEST)) break block18;
                    logger.finest(this + ": ignored exception: " + sQLServerException);
                }
            }
            if (this.attentionPending) {
                logger.severe(this + ": expected attn ack missing or not processed; terminating connection...");
                try {
                    this.tdsReader.throwInvalidTDS();
                }
                catch (SQLServerException sQLServerException) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this + ": ignored expected invalid TDS exception: " + sQLServerException);
                    }
                    assert (this.tdsReader.getConnection().isSessionUnAvailable());
                    this.attentionPending = false;
                }
            }
        }
        assert (this.processedResponse && !this.attentionPending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt(String string) throws SQLServerException {
        Object object = this.interruptLock;
        synchronized (object) {
            if (this.interruptsEnabled && !this.wasInterrupted()) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this + ": Raising interrupt for reason:" + string);
                }
                this.wasInterrupted = true;
                this.interruptReason = string;
                if (this.requestComplete) {
                    this.attentionPending = this.tdsWriter.sendAttention();
                }
            }
        }
    }

    final void checkForInterrupt() throws SQLServerException {
        if (this.wasInterrupted() && !this.interruptChecked) {
            this.interruptChecked = true;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this + ": throwing interrupt exception, reason: " + this.interruptReason);
            }
            throw new SQLServerException(this.interruptReason, SQLState.STATEMENT_CANCELED, DriverError.NOT_SET, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onRequestComplete() throws SQLServerException {
        assert (!this.requestComplete);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": request complete");
        }
        Object object = this.interruptLock;
        synchronized (object) {
            this.requestComplete = true;
            if (!this.interruptsEnabled) {
                assert (!this.attentionPending);
                assert (!this.processedResponse);
                assert (!this.readingResponse);
                this.processedResponse = true;
            } else if (this.wasInterrupted()) {
                if (this.tdsWriter.isEOMSent()) {
                    this.readingResponse = this.attentionPending = this.tdsWriter.sendAttention();
                } else {
                    assert (!this.attentionPending);
                    this.readingResponse = this.tdsWriter.ignoreMessage();
                }
                this.processedResponse = !this.readingResponse;
            } else {
                assert (!this.attentionPending);
                assert (!this.processedResponse);
                this.readingResponse = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onResponseEOM() throws SQLServerException {
        boolean bl = false;
        Object object = this.interruptLock;
        synchronized (object) {
            if (this.interruptsEnabled) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this + ": disabling interrupts");
                }
                bl = this.attentionPending;
                this.interruptsEnabled = false;
            }
        }
        if (bl) {
            this.tdsReader.readPacket();
        }
        this.readingResponse = false;
    }

    final void onTokenEOF() {
        this.processedResponse = true;
    }

    final void onAttentionAck() {
        assert (this.attentionPending);
        this.attentionPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TDSWriter startRequest(byte by) throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": starting request...");
        }
        try {
            this.tdsWriter.startMessage(this, by);
        }
        catch (SQLServerException sQLServerException) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this + ": starting request: exception: " + sQLServerException.getMessage());
            }
            throw sQLServerException;
        }
        Object object = this.interruptLock;
        synchronized (object) {
            this.requestComplete = false;
            this.readingResponse = false;
            this.processedResponse = false;
            this.attentionPending = false;
            this.wasInterrupted = false;
            this.interruptReason = null;
            this.interruptsEnabled = true;
        }
        return this.tdsWriter;
    }

    final TDSReader startResponse() throws SQLServerException {
        return this.startResponse(false);
    }

    final TDSReader startResponse(boolean bl) throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + ": finishing request");
        }
        try {
            this.tdsWriter.endMessage();
        }
        catch (SQLServerException sQLServerException) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this + ": finishing request: endMessage threw exception: " + sQLServerException.getMessage());
            }
            throw sQLServerException;
        }
        if (null != this.timeoutTimer) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Starting timer...");
            }
            this.timeoutTimer.start();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": Reading response...");
        }
        try {
            if (bl) {
                this.tdsReader.readPacket();
            } else {
                while (this.tdsReader.readPacket()) {
                }
            }
        }
        catch (SQLServerException sQLServerException) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Exception reading response: " + sQLServerException.getMessage());
            }
            throw sQLServerException;
        }
        finally {
            if (null != this.timeoutTimer) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.toString() + ": Stopping timer...");
                }
                this.timeoutTimer.stop();
            }
        }
        return this.tdsReader;
    }
}

