package com.mwstys.android.permission;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.app.AlertDialog;

import com.humandevice.android.core.view.interfaces.ActivityResultListener;
import com.humandevice.android.core.view.interfaces.ContextOperator;

/**
 * Helper class to enable location
 *
 * @author Mikołaj Styś
 * @date 2016/03/20
 */
public class EnableLocationHelper implements ActivityResultListener {

    private static final int CODE_LOCATION = 105;
    private ContextOperator mContextOperator;
    private LocationEnabledListener mListener;

    public EnableLocationHelper(ContextOperator contextOperator) {
        mContextOperator = contextOperator;
    }

    public void setEnableListener(@NonNull LocationEnabledListener listener) {
        mListener = listener;
    }

    public void openLocationSettings() {
        Intent myIntent = new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS);
        mContextOperator.startActivityForResult(myIntent, CODE_LOCATION, null);
    }

    public void request() {
        if (!isNetworkLocationEnabled()) {
            mListener.onShowLocationMessage();
        } else {
            mListener.onLocationEnabled();
        }
    }

    protected boolean isNetworkLocationEnabled() {
        LocationManager locationManager = (LocationManager) mContextOperator.getContext().getSystemService(Context.LOCATION_SERVICE);
        try {
            return locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public void onActivityResultPropagated(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == CODE_LOCATION) {
            if(isNetworkLocationEnabled()) {
                mListener.onLocationEnabled();
            } else {
                mListener.onLocationDisabled();
            }
        }
    }

    public interface LocationEnabledListener {
        void onLocationEnabled();
        void onLocationDisabled();
        void onShowLocationMessage();
    }
}
